/*************************************

Template Name: Sunlite Mortgage Template
Author: Jonayed Islam
Author Url: http://jonayed.com
Version: 1.0
Design and Developed by: Bongosoft Ltd.

****************************************/

(function($) {
    "use strict";

    var $window = $(window),
        $body = $('body');

/*=============================
    PRELOADER JS
==============================*/

jQuery(window).on('load', function() {
  jQuery(".loader").fadeOut(500);
});

/*=============================
    Back To Top
==============================*/
//Make sure the user has scrolled at least double the height of the browser
  var toggleHeight = $(window).outerHeight();

  $(window).scroll(function() {
         if ($(window).scrollTop() > toggleHeight) {
           //Adds active class to make button visible
           $(".m-backtotop").addClass("active");

         } else {
           //Removes active class to make button visible
           $(".m-backtotop").removeClass("active");
         }
       });

       //Scrolls the user to the top of the page again
       $(".m-backtotop").click(function() {
         $("html, body").animate({ scrollTop: 0 }, "slow");
         return false;
       });

       /*=============================
           OWL CAROUSEL
       ==============================*/

       $(".banner-slider").owlCarousel({
         items: 1,
         loop: true,
         margin: 15,
         singleItem: true,
         nav: true,
         dots: false,
         smartSpeed: 1000,
         autoplay: true,
         autoplayTimeout: 4000,
         autoplayHoverPause: true,
         navText: [
           "<i class='fa fa-long-arrow-left'></i>",
           "<i class='fa fa-long-arrow-right'></i>",
         ],
       });

       $(".clients-testimonial-slider").owlCarousel({
         items: 3,
         loop: true,
         margin: 30,
         nav: true,
         dots: false,
         smartSpeed: 1500,
         autoplay: true,
         autoplayTimeout: 4000,
         autoplayHoverPause: true,
         navText: [
           "<i class='fa fa-angle-double-left'></i>",
           "<i class='fa fa-angle-double-right'></i>",
         ],
         responsiveClass:true,
             responsive:{
                 0:{
                  items:1,
                 },
                 600:{
                  items:2,
                 },
                 1000:{
                  items:3,
                 }
              }
       });

       $(".lenders-logo-slider").owlCarousel({
         loop: true,
         margin: 40,
         nav: true,
         dots: false,
         smartSpeed: 500,
         autoplay: true,
         autoplayTimeout: 1000,
         autoplayHoverPause: true,
         navText: [
           "<i class='fa fa-angle-double-left'></i>",
           "<i class='fa fa-angle-double-right'></i>",
         ],
         responsiveClass:true,
             responsive:{
                 0:{
                  items:2,
                 },
                 600:{
                  items:4,
                 },
                 1000:{
                  items:5,
            }
        }
        
       });

       $('.four-step-slider').owlCarousel({
         center: true,
         items: 4,
         loop: true,
         margin: 50,
         nav: false,
         dots: false,
         smartSpeed: 1100,
         autoplay: true,
         autoplayTimeout: 3000,
         autoplayHoverPause: true,
         responsive: {
             0: {
                 items: 1,
             },
             600: {
                 items: 2,
             },
             1000: {
                 items: 4,
             }
         }
       });

       /*=============================
           MAGNIFIC POP UP
       ==============================*/
       $(".popup-youtube").magnificPopup({
           disableOn: 320,
           type: "iframe",
           mainClass: "mfp-fade",
           removalDelay: 160,
           preloader: false,
           fixedContentPos: false,
         });
         /*=============================
             FOR COUNTER
         ==============================*/
         if ($(".odometer").length) {
           $(".odometer").appear(function (e) {
             var odo = $(".odometer");
             odo.each(function () {
               var countNumber = $(this).attr("data-count");
               $(this).html(countNumber);
             });
           });
         }

    /*=============================
        FOR FAQ PAGE ACCORDION
    ==============================*/
    $("#accordion .collapse").on("shown.bs.collapse", function () {
       $(this).prev().addClass("active");
       $(this).prev().parent().addClass("active");
     });

     $("#accordion .collapse").on("hidden.bs.collapse", function () {
       $(this).prev().removeClass("active");
       $(this).prev().parent().removeClass("active");
     });

     $("#accordion").on("hide.bs.collapse show.bs.collapse", (e) => {
       $(e.target).prev().find("i:last-child").toggleClass("fa-plus fa-minus");
     });


 })(jQuery);

 // FOR TOP NAV SHOW ON UPSCROLL

// var prevScrollpos = window.pageYOffset;
//   window.onscroll = function() {
//   var currentScrollpos = window.pageYOffset;
//   if (prevScrollpos > currentScrollpos) {
//           document.getElementById("header").style.top = "0";
//   } else {
//         document.getElementById("header").style.top = "-100px";
//   }
//   prevScrollpos = currentScrollpos;
//   };

// (function ($) {
//   "use strict";
//
//
//   if ($(".odometer").length) {
//     $(".odometer").appear(function (e) {
//       var odo = $(".odometer");
//       odo.each(function () {
//         var countNumber = $(this).attr("data-count");
//         $(this).html(countNumber);
//       });
//     });
//   }
//
//
// })(jQuery);
